// nfw functions
//
//===========================================================================
// History:
// 19dec03 - revised GetHelpPathLink and GetHelpPathText to use path defined 
//	at registry key specified by localUserRegPath. If useRegPath is set 
//	to 1 the registry path is used, else the current path is used.
// 26nov03 - created "str_exercises" variable
// 17nov03 - added OpenExercise and checkTOC functions
// 04nov03 - added OpenPDF function
// 04nov03 - commented out code that operates on top nav images in setButton
// 03apr03 - added loadFrame
// 17mar03 - fixed formatting of GetHelpPathLink
// 12mar03 - added getcurpath2, GetNfwPathLink, and GetNfwPath functions
//===========================================================================
// LOCALIZATION
//
var str_onlastpage 	= "You are on the last page.";
var str_onfirstpage 	= "You are on the first page.";
var str_nextpage 	= "Next page";
var str_prevpage 	= "Previous page";
var str_exercises	= "Tutorials";
var localUserRegPath    = "HKEY_CURRENT_USER\\Software\\Autodesk\\AutoCAD\\R16.1\\ACAD-301:409\\LocalRootFolder";

//===========================================================================
// GLOBAL VARIABLES
//
var useRegPath = 0;  // if == 1, the registry path defined by localUserRegPath is used
var curfile    = "";
var okbotimg   = 0;
var okWsh      = 1;

//===========================================================================
//
if( useRegPath == 1 ) {
  try { var WshShell = new ActiveXObject("WScript.Shell"); }
  catch(e) { okWsh = 0; }
}

//===========================================================================
// doBrowse - enables back and next browsing
//
// This assumes that 'browselist' is defined elsewhere
//
// <direction> = the number of pages that are skipped, use 1 for next 
//               and -1 for back.
//
function doBrowse(direction) {
  curfile = document.all.curfile.value
  var ct = 0;
  for( var num in browselist ) {
    var file = browselist[num];
    if( curfile == file ) {
      var newfile = browselist[ct+direction];
    }
    ct++;
  }
  if( newfile ) { document.all.ifrm.src=newfile; }
  else {
    //if( direction == 1 ) { alert(str_onlastpage); }
    //else { alert(str_onfirstpage); }
  }
}

//===========================================================================
// loadFrame - loads the first step of the exercise 

function loadFrame() {
  document.all.ifrm.src=browselist[1];
}

//===========================================================================
// setButton - sets the appropriate nav "button" for the lesson.
//
// This assumes that all button IMG object names are "imageN" starting with "image1"
//
// <imgnum>  = the number associated with the "image" object 
// <numbtns> = the number of buttons (lessons)

function setButton(imgnum,numbtns) {
  var ct = 0;
  if( okbotimg == 1 ) {
    var i = 1;
    while( i <= numbtns ) {
      //eval("parent.document.image"+i+".src='numoff"+i+".gif';");
      eval("parent.document.botimage"+i+".src='numoff"+i+".gif';");
      i++;
    }
    //eval("parent.document.image"+imgnum+".src='numon"+imgnum+".gif';");
    eval("parent.document.botimage"+imgnum+".src='numon"+imgnum+".gif';");
    document.all.curfile.value = browselist[imgnum]
    if( imgnum == 1 ) { 
      //parent.document.prevarrow1.src="l_arrow_off.gif";
      parent.document.prevarrow2.src="l_arrow_off.gif";
      //parent.document.prevarrow1.title=str_onfirstpage;
      parent.document.prevarrow2.title=str_onfirstpage;
    }
    else {
      //parent.document.prevarrow1.src="l_arrow.gif";
      parent.document.prevarrow2.src="l_arrow.gif";
      //parent.document.prevarrow1.title=str_prevpage;
      parent.document.prevarrow2.title=str_prevpage;
    }
    if( imgnum == numbtns ) { 
      //parent.document.nextarrow1.src="r_arrow_off.gif";
      parent.document.nextarrow2.src="r_arrow_off.gif";
      //parent.document.nextarrow1.title=str_onlastpage;
      parent.document.nextarrow2.title=str_onlastpage;
    }
    else {
      //parent.document.nextarrow1.src="r_arrow.gif";
      parent.document.nextarrow2.src="r_arrow.gif";
      //parent.document.nextarrow1.title=str_nextpage;
      parent.document.nextarrow2.title=str_nextpage;
    }
  }
}

//===========================================================================
// setsize - adjusts the size of the iframe so the scrollbars align properly
//
// add to onload and onresize events

function setsize() {
  // if botimg1 exists, set the siz to 32, else set it to 0
  try {
    zz = document.all.botimage1.src;
    var siz = 32;
    okbotimg = 1;
  }
  catch(e) {
    var siz = 0;
  }
  if( navigator.appName == "Microsoft Internet Explorer" ) {
    var ht = document.body.clientHeight - document.all.ifrm.offsetTop;
    if( ht > siz ) {
      document.all.ifrm.style.height = ht-siz;
    }
  }
}

//===========================================================================

function MakeArray(n) {
  this.length = n;
  for (var i = 1; i <= n; i++) { 
    this[i] = 0 
  }
  return this
}

//===========================================================================

function getcurpath2 () {
  var path = unescape(location.pathname);
  if( path.indexOf("@MSITStore:") == 0 ) {
    path = path.substring(11,path.length);
  }
  if( path.indexOf("/") == 0 ) {
    path = path.substring(1,path.length);
  }
  var i = path.lastIndexOf("\\");
  var j = 0;
  path = path.substring(j,i+1);
  return path;
}

function GetHelpPathLink (extra) {
  if( useRegPath == 1 ) { 
    if( okWsh == 1 ) { var path = WshShell.RegRead (localUserRegPath); }
    else { path = "LOCALROOTPREFIX - "; }
  }
  else { var path = getcurpath2(); }
  if( extra == null ) { extra = ""; }
  var ex = extra.replace(/\\/g, "/");
  var pathstr = path;
  //return "<a href='file://" + path + ex + "' class=pathlink target=path>" + pathstr + "\\" + extra + "</a>";
  return "<a href='file://" + path + ex + "' class=pathlink target=path>" + pathstr + extra + "</a>";
}

function GetHelpPathText (extra) {
  if( useRegPath == 1 ) { 
    if( okWsh == 1 ) { var path = WshShell.RegRead (localUserRegPath); }
    else { path = "LOCALROOTPREFIX - "; }
  }
  else { var path = getcurpath2(); }
  if( extra == null ) { extra = ""; }
  //return path + "\\" + extra;
  return path + extra;
}

function OLDGetHelpPathLink (extra) {
  var path = getcurpath2();
  if( extra == null ) { extra = ""; }
  var ex = extra.replace(/\\/g, "/");
  var pathstr = path;
  //var pathstr = path.replace(/\\/g, "\\ ");;
  return "<a href='file://" + path + ex + "' class=pathlink target=path>" + pathstr + extra + "</a>";
}

function OLDGetHelpPathText (extra) {
  var path = getcurpath2();
  if( extra == null ) { extra = ""; }
  return path + extra;
}

function OpenPDF (file) {
  var path = getcurpath2();
  window.open("file://"+path+file,"pdf","scrollbars=yes,resizable=yes,width=500,height=500");
}

// OpenExercise - Opens the exercise defined by the object id
//
function OpenExercise(eid) {
  eval(eid+".Click();");
}

// checkTOC - used with "noflash" file
//
function checkTOC () {
  nfwtoc = window.location.hash;
  if( nfwtoc == "#noflash" ) {
    backlink.innerHTML = str_exercises;
    backlink.href = "../noflash.html";
  }
}

// SIG // Begin signature block
// SIG // MIIMzQYJKoZIhvcNAQcCoIIMvjCCDLoCAQExDjAMBggq
// SIG // hkiG9w0CBQUAMGYGCisGAQQBgjcCAQSgWDBWMDIGCisG
// SIG // AQQBgjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIB
// SIG // AAIBAAIBAAIBAAIBADAgMAwGCCqGSIb3DQIFBQAEEM4u
// SIG // I2f6LzCZ+A4JURfdQCmgggoPMIIE/DCCBGWgAwIBAgIQ
// SIG // ZVIm4bIuGOFZDymFrCLnXDANBgkqhkiG9w0BAQUFADBf
// SIG // MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24s
// SIG // IEluYy4xNzA1BgNVBAsTLkNsYXNzIDMgUHVibGljIFBy
// SIG // aW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcN
// SIG // MDkwNTIxMDAwMDAwWhcNMTkwNTIwMjM1OTU5WjCBtjEL
// SIG // MAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJ
// SIG // bmMuMR8wHQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3
// SIG // b3JrMTswOQYDVQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0
// SIG // cHM6Ly93d3cudmVyaXNpZ24uY29tL3JwYSAoYykwOTEw
// SIG // MC4GA1UEAxMnVmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNp
// SIG // Z25pbmcgMjAwOS0yIENBMIIBIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAQ8AMIIBCgKCAQEAvmcdtGCqEElvVhd8Zslehg3V
// SIG // 8ayncYOOi4n4iASJFQa6LYQhleTRnFBM+9IivdrysjU7
// SIG // Ho/DCfv8Ey5av4l8PTslHvbzWHuc9AG1xgq4gM6+J3Rh
// SIG // ZydNauXsgWFYeaPgFxASFSew4U00fytHIES53mYkZorN
// SIG // T7ofxTjIVJDhcvYZZnVquUlozzh5DaowqNssYEie16oU
// SIG // AamD1ziRMDkTlgM6fEBUtq3gLxuD3KgRUj4Cs9cr/SG2
// SIG // p1yjDwupphBQDjQuTafOyV4l1Iy88258KbwBXfwxh1rV
// SIG // jIVnWIgZoL818OoroyHnkPaD5ajtYHhee2CD/VcLXUEN
// SIG // Y1Rg1kMh7wIDAQABo4IB2zCCAdcwEgYDVR0TAQH/BAgw
// SIG // BgEB/wIBADBwBgNVHSAEaTBnMGUGC2CGSAGG+EUBBxcD
// SIG // MFYwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9jcHMwKgYIKwYBBQUHAgIwHhocaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTAOBgNVHQ8BAf8E
// SIG // BAMCAQYwbQYIKwYBBQUHAQwEYTBfoV2gWzBZMFcwVRYJ
// SIG // aW1hZ2UvZ2lmMCEwHzAHBgUrDgMCGgQUj+XTGoasjY5r
// SIG // w8+AatRIGCx7GS4wJRYjaHR0cDovL2xvZ28udmVyaXNp
// SIG // Z24uY29tL3ZzbG9nby5naWYwHQYDVR0lBBYwFAYIKwYB
// SIG // BQUHAwIGCCsGAQUFBwMDMDQGCCsGAQUFBwEBBCgwJjAk
// SIG // BggrBgEFBQcwAYYYaHR0cDovL29jc3AudmVyaXNpZ24u
// SIG // Y29tMDEGA1UdHwQqMCgwJqAkoCKGIGh0dHA6Ly9jcmwu
// SIG // dmVyaXNpZ24uY29tL3BjYTMuY3JsMCkGA1UdEQQiMCCk
// SIG // HjAcMRowGAYDVQQDExFDbGFzczNDQTIwNDgtMS01NTAd
// SIG // BgNVHQ4EFgQUl9BrqCZwyKE/lB8ILcQ1m6ShHvIwDQYJ
// SIG // KoZIhvcNAQEFBQADgYEAiwPA3ZTYQaJhabAVqHjHMMaQ
// SIG // PH5C9yS25INzFwR/BBCcoeL6gS/rwMpE53LgULZVECCD
// SIG // bpaS5JpRarQ3MdylLeuMAMcdT+dNMrqF+E6++mdVZfBq
// SIG // vnrKZDgaEBB4RXYx84Z6Aw9gwrNdnfaLZnaCG1nhg+W9
// SIG // SaU4VuXeQXcOWA8wggULMIID86ADAgECAhAjTaBL0kKF
// SIG // PErLmuhhwhm7MA0GCSqGSIb3DQEBBQUAMIG2MQswCQYD
// SIG // VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4x
// SIG // HzAdBgNVBAsTFlZlcmlTaWduIFRydXN0IE5ldHdvcmsx
// SIG // OzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBhdCBodHRwczov
// SIG // L3d3dy52ZXJpc2lnbi5jb20vcnBhIChjKTA5MTAwLgYD
// SIG // VQQDEydWZXJpU2lnbiBDbGFzcyAzIENvZGUgU2lnbmlu
// SIG // ZyAyMDA5LTIgQ0EwHhcNMDkwODI3MDAwMDAwWhcNMTIw
// SIG // OTIwMjM1OTU5WjCByDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCkNhbGlmb3JuaWExEzARBgNVBAcTClNhbiBSYWZh
// SIG // ZWwxFjAUBgNVBAoUDUF1dG9kZXNrLCBJbmMxPjA8BgNV
// SIG // BAsTNURpZ2l0YWwgSUQgQ2xhc3MgMyAtIE1pY3Jvc29m
// SIG // dCBTb2Z0d2FyZSBWYWxpZGF0aW9uIHYyMR8wHQYDVQQL
// SIG // FBZEZXNpZ24gU29sdXRpb25zIEdyb3VwMRYwFAYDVQQD
// SIG // FA1BdXRvZGVzaywgSW5jMIGfMA0GCSqGSIb3DQEBAQUA
// SIG // A4GNADCBiQKBgQC1R1YKdvQF2Rj4+knWfj81afUtVyep
// SIG // GF2P4tcYD53qlYmYi9t9Csc6PMWlUZhMGbOceQKYcBjc
// SIG // mWvyghJnoaEQ6796ZcsLD0pMH2R4SpV/SjxiQ280beig
// SIG // NerJS5X+ftOMCs1qSQ1LXlRFEohaewkNWsIp/+f1Y0vE
// SIG // dGzggnEKOQIDAQABo4IBgzCCAX8wCQYDVR0TBAIwADAO
// SIG // BgNVHQ8BAf8EBAMCB4AwRAYDVR0fBD0wOzA5oDegNYYz
// SIG // aHR0cDovL2NzYzMtMjAwOS0yLWNybC52ZXJpc2lnbi5j
// SIG // b20vQ1NDMy0yMDA5LTIuY3JsMEQGA1UdIAQ9MDswOQYL
// SIG // YIZIAYb4RQEHFwMwKjAoBggrBgEFBQcCARYcaHR0cHM6
// SIG // Ly93d3cudmVyaXNpZ24uY29tL3JwYTATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB1BggrBgEFBQcBAQRpMGcwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLnZlcmlzaWduLmNvbTA/
// SIG // BggrBgEFBQcwAoYzaHR0cDovL2NzYzMtMjAwOS0yLWFp
// SIG // YS52ZXJpc2lnbi5jb20vQ1NDMy0yMDA5LTIuY2VyMB8G
// SIG // A1UdIwQYMBaAFJfQa6gmcMihP5QfCC3ENZukoR7yMBEG
// SIG // CWCGSAGG+EIBAQQEAwIEEDAWBgorBgEEAYI3AgEbBAgw
// SIG // BgEBAAEB/zANBgkqhkiG9w0BAQUFAAOCAQEAIfxkh8Fd
// SIG // IHK+qtTf+9Eq5fjkk5gMMTQCOa+2aR7mqDzLfIFRGQzr
// SIG // tcc5/izsb/wPLUwdw1cRpnxO8/qLA2Ol+b99FONTOyyc
// SIG // Y8unwviYhdEjuFmqHkyC5MUYroZEjvTObFkkgN98Y48h
// SIG // C+mG2hdlVKXR0zr9r5q/rmmivVWbojvcYKHoW31O5OcM
// SIG // PsrWuOD305Ygmpck/91iopE3UN4tfeWYhzNj1F6Ai4Xa
// SIG // 5KiaMcs3zmoZ+6SePyI2YUgtff6yvy/rk8KVT41KGD2h
// SIG // fC+QrtVSkoDWP/MDtLjbTPCWElC1NWSEKowRI8t2x594
// SIG // Skjnzu/W5Lh97ixircOuM4IvBzGCAigwggIkAgEBMIHL
// SIG // MIG2MQswCQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNp
// SIG // Z24sIEluYy4xHzAdBgNVBAsTFlZlcmlTaWduIFRydXN0
// SIG // IE5ldHdvcmsxOzA5BgNVBAsTMlRlcm1zIG9mIHVzZSBh
// SIG // dCBodHRwczovL3d3dy52ZXJpc2lnbi5jb20vcnBhIChj
// SIG // KTA5MTAwLgYDVQQDEydWZXJpU2lnbiBDbGFzcyAzIENv
// SIG // ZGUgU2lnbmluZyAyMDA5LTIgQ0ECECNNoEvSQoU8Ssua
// SIG // 6GHCGbswDAYIKoZIhvcNAgUFAKCBsDAZBgkqhkiG9w0B
// SIG // CQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
// SIG // DAYKKwYBBAGCNwIBFTAfBgkqhkiG9w0BCQQxEgQQI6oi
// SIG // Bxic5msOyutobfXG3zBUBgorBgEEAYI3AgEMMUYwRKAm
// SIG // gCQAQQB1AHQAbwBkAGUAcwBrACAAQwBvAG0AcABvAG4A
// SIG // ZQBuAHShGoAYaHR0cDovL3d3dy5hdXRvZGVzay5jb20g
// SIG // MA0GCSqGSIb3DQEBAQUABIGAsCc++hv7taIwkVDfXNcz
// SIG // 8C7oHH5yeyIuLRcufG07jpY90qcPY848dl6HecL0uPof
// SIG // K4jCrK7lDzGYdhfXv4szgHWBJS0RRVFJyAwXYDeUXn6I
// SIG // vBgTNp2CbI4Af8dQES8waf2z6n46YhSrYD3js1o0pFXy
// SIG // Nc2wDrnrXIxFu0MnrzE=
// SIG // End signature block
